//
//  Adding_Persons_to_GroupsAppDelegate.m
//  Adding Persons to Groups
//
//  Created by Vandad Nahavandipoor on 21/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Adding_Persons_to_GroupsAppDelegate.h"

@implementation Adding_Persons_to_GroupsAppDelegate

@synthesize window = _window;

- (ABRecordRef) newGroupWithName:(NSString *)paramGroupName
                   inAddressBook:(ABAddressBookRef)paramAddressBook{
  
  ABRecordRef result = NULL;
  
  if (paramAddressBook == NULL){
    NSLog(@"Książka adresowa ma wartość nil.");
    return NULL;
  }
  
  result = ABGroupCreate();
  
  if (result == NULL){
    NSLog(@"Nie udało się utworzyć nowej grupy.");
    return NULL;
  }
  
  BOOL couldSetGroupName = NO;
  CFErrorRef error = NULL;
  
  couldSetGroupName = ABRecordSetValue(result,
                                       kABGroupNameProperty,
                                       (__bridge CFTypeRef)paramGroupName,
                                       &error);
  
  if (couldSetGroupName){
    
    BOOL couldAddRecord = NO;
    CFErrorRef couldAddRecordError = NULL;
    
    couldAddRecord = ABAddressBookAddRecord(paramAddressBook, 
                                            result,
                                            &couldAddRecordError);
    
    if (couldAddRecord){
      
      NSLog(@"Udało się dodać nową grupę.");
      
      if (ABAddressBookHasUnsavedChanges(paramAddressBook)){
        BOOL couldSaveAddressBook = NO;
        CFErrorRef couldSaveAddressBookError = NULL;
        couldSaveAddressBook = ABAddressBookSave(paramAddressBook, 
                                                 &couldSaveAddressBookError);
        if (couldSaveAddressBook){
          NSLog(@"Udało się zapisać zmiany w książce adresowej.");
        } else {
          CFRelease(result);
          result = NULL;
          NSLog(@"Nie udało się zapisać zmian w książce adresowej.");
        }
      } else {
        CFRelease(result);
        result = NULL;
        NSLog(@"Brak niezapisanych zmian.");
      }
    } else {
      CFRelease(result);
      result = NULL;
      NSLog(@"Nie udało się dodać nowej grupy.");
    }
  } else {
    CFRelease(result);
    result = NULL;
    NSLog(@"Nie udało się przypisać nazwy grupie.");
  }
  
  return result;
  
}

- (ABRecordRef) newPersonWithFirstName:(NSString *)paramFirstName
                              lastName:(NSString *)paramLastName
                         inAddressBook:(ABAddressBookRef)paramAddressBook{
  
  ABRecordRef result = NULL;
  
  if (paramAddressBook == NULL){
    NSLog(@"Książka adresowa ma wartość NULL.");
    return NULL;
  }
  
  if ([paramFirstName length] == 0 &&
      [paramLastName length] == 0){
    NSLog(@"Nie podano imienia i nazwiska.");
    return NULL;
  }
  
  result = ABPersonCreate();
  
  if (result == NULL){
    NSLog(@"Nie udało się utworzyć nowego kontaktu.");
    return NULL;
  }
  
  BOOL couldSetFirstName = NO;
  BOOL couldSetLastName = NO;
  CFErrorRef setFirstNameError = NULL;
  CFErrorRef setLastNameError = NULL;
  
  couldSetFirstName = ABRecordSetValue(result,
                                       kABPersonFirstNameProperty,
                                       (__bridge CFTypeRef)paramFirstName,
                                       &setFirstNameError);
  
  couldSetLastName = ABRecordSetValue(result,
                                      kABPersonLastNameProperty,
                                      (__bridge CFTypeRef)paramLastName,
                                      &setLastNameError);
  
  CFErrorRef couldAddPersonError = NULL;
  BOOL couldAddPerson = ABAddressBookAddRecord(paramAddressBook,
                                               result,
                                               &couldAddPersonError);
  
  if (couldAddPerson){
    NSLog(@"Udało się dodać nowy kontakt.");
  } else {
    NSLog(@"Nie udało się dodać nowego kontaktu.");
    CFRelease(result);
    result = NULL;
    return result;
  }
  
  if (ABAddressBookHasUnsavedChanges(paramAddressBook)){
    
    CFErrorRef couldSaveAddressBookError = NULL;
    BOOL couldSaveAddressBook = ABAddressBookSave(paramAddressBook, 
                                                  &couldSaveAddressBookError);
    
    if (couldSaveAddressBook){
      NSLog(@"Udało się zapisać zmiany w książce adresowej.");
    } else {
      NSLog(@"Nie udało się zapisać zmian w książce adresowej.");
    }
  }
  
  if (couldSetFirstName &&
      couldSetLastName){
    NSLog(@"Udało się zmienić imię i nazwisko kontaktu w książce adresowej.");
  } else {
    NSLog(@"Nie udało się zmienić imienia i nazwiska kontaktu w książce adresowej.");
  }
  
  return result;
  
}

- (BOOL)    addPerson:(ABRecordRef)paramPerson
              toGroup:(ABRecordRef)paramGroup
    saveToAddressBook:(ABAddressBookRef)paramAddressBook{
  
  BOOL result = NO;
  
  if (paramPerson == NULL ||
      paramGroup == NULL ||
      paramAddressBook == NULL){
    NSLog(@"Podano nieprawidłowe parametry.");
    return NO;
  }
  
  CFErrorRef error = NULL;
  
  /* Próba dodania kontaktu do grupy. */
  result = ABGroupAddMember(paramGroup,
                            paramPerson,
                            &error);
  
  if (result == NO){
    NSLog(@"Nie udało się dodać kontaktu do grupy.");
    return result;
  }
  
  /* Upewnienie się o zapisaniu wszelkich niezapisanych zmian. */
  if (ABAddressBookHasUnsavedChanges(paramAddressBook)){
    BOOL couldSaveAddressBook = NO;
    CFErrorRef couldSaveAddressBookError = NULL;
    couldSaveAddressBook = ABAddressBookSave(paramAddressBook, 
                                             &couldSaveAddressBookError);
    if (couldSaveAddressBook){
      NSLog(@"Udało się dodać nowy kontakt to the group.");
      result = YES; 
    } else {
      NSLog(@"Nie udało się zapisać zmian w książce adresowej.");
    }
  } else {
    NSLog(@"Nie zapisano żadnych zmian.");
  }
  
  return result;
  
}

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  ABAddressBookRef addressBook = ABAddressBookCreate();
  
  if (addressBook != nil){
    
    ABRecordRef nataliaMalinowska = [self newPersonWithFirstName:@"Natalia"
                                                   		  lastName:@"Malinowska"
                                               		 inAddressBook:addressBook];
    
    if (nataliaMalinowska != NULL){
      
      ABRecordRef entrepreneursGroup = [self newGroupWithName:@"Trenerzy"
                                                inAddressBook:addressBook];
      
      if (entrepreneursGroup != NULL){
        
        if ([self addPerson:nataliaMalinowska
                    toGroup:entrepreneursGroup
          saveToAddressBook:addressBook]){
          
          NSLog(@"Udało się dodać kontakt Natalia Malinowska \
                  do grupy Trenerzy");
          
        } else {
          NSLog(@"Nie udało się dodać kontaktu Natalia Malinowska \
                  do grupy Trenerzy.");
        }
        
        CFRelease(entrepreneursGroup);
      } else {
        NSLog(@"Nie udało się utworzyć grupy Trenerzy.");
      }
      
      CFRelease(nataliaMalinowska);
    } else {
      NSLog(@"Nie udało się utworzyć kontaktu Natalia Malinowska.");
    }
    
    CFRelease(addressBook);
  } else {
    NSLog(@"Książka adresowa ma wartość nil.");
  }
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
